﻿using System;
using Microsoft.SharePoint.Client;

namespace AddListItem
{
   class Program
   {
      static void Main(string[] args)
      {
         ClientContext ctx = new ClientContext("http://contoso.de");

         Web web = ctx.Web;
         List listCustomers = web.Lists.GetByTitle("Kunden");

         // Neues ListItemCreationInformation-Objekt erzeugen
         ListItemCreationInformation customerItemCreationInformation =
            new ListItemCreationInformation();

         // Neues Kundenelement erzeugen
         ListItem customerItem = listCustomers.AddItem(customerItemCreationInformation);
         customerItem["Title"] = "Helfrecht";
         customerItem["FirstName"] = "Fritz";
         customerItem["Company"] = "Contoso GmbH";
         customerItem.Update();

         ctx.ExecuteQuery();

         Console.WriteLine("Neuer Kunde wurde erfolgreich erstellt: {0} ({1})",
            customerItem.Id,
            customerItem["Title"].ToString());

         // Referenz auf den Artikel
         List listArticle = web.Lists.GetByTitle("Artikel");
         ListItem anyArticleItem = listArticle.GetItemById(1);

         // Artikel-ID laden
         ctx.Load(anyArticleItem,
            item => item.Id);

         ctx.ExecuteQuery();

         // Neue Bestellung erzeugen
         List listOrders = web.Lists.GetByTitle("Bestellungen");

         ListItemCreationInformation orderItemCreationInformation =
            new ListItemCreationInformation();

         ListItem orderItem = listOrders.AddItem(orderItemCreationInformation);
         orderItem["Title"] = Guid.NewGuid().ToString();
         orderItem["Artikel"] = anyArticleItem.Id;
         orderItem["Kunde"] = customerItem.Id;
         orderItem["Menge"] = 1.0;
         orderItem.Update();

         ctx.ExecuteQuery();

         Console.WriteLine("Neue Bestellung wurde erfolgreich erzeugt: {0} ({1})",
            orderItem.Id,
            orderItem["Title"].ToString());
      }
   }
}